% *************************************************************************
% 
%                      iGem Modelling - 2018
%                     Delft University of Technology
% 
% *************************************************************************
% 
%               Title
% 
%                    File: Steady State Analysis of Red Blood Cell
%                    Production
% 
%              
% *************************************************************************
clear all
close all
%Read in results from main model
Results1 = xlsread('Steady_State_Convergence.xlsx');

%Figure
figure(1)
plot(Results1(:,1), Results1(:,2), 'LineWidth',3); hold on;
plot(Results1(:,1), Results1(:,3), 'LineWidth',3);
plot(Results1(:,1), Results1(:,4), 'LineWidth',3);
plot(Results1(:,1), Results1(:,5), 'LineWidth',3);
xlim([0 500]);
set(gcf,'color','w'); 
set(gca,'fontsize',16);
set(gcf, 'Position', [500, 200, 800, 700])
xlabel('Time (days)');
ylabel('Red Blood Cell Population (# of cells x10^{12})');
legend('Initial population: 0 cells at each maturity', 'Initial population: SS cell count at each maturity', ...
    'Initial population: 10^{10} cells at each maturity', 'Initial population: 10^{11} cells at each maturity')